/*
THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES INC. ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE
DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES INC. BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

YOU ASSUME ANY AND ALL RISK FROM THE USE OF THIS CODE OR SUPPORT FILE.

IT IS THE RESPONSIBILITY OF THE PERSON INTEGRATING THIS CODE INTO AN APPLICATION
TO ENSURE THAT THE RESULTING APPLICATION PERFORMS AS REQUIRED AND IS SAFE.

    Module       : bsp.h
    Description  : Board support package
    Date         : 10 June 2010
    Version      : v1.00
    Changelog    : v1.00 Initial
*/

//*****************************************************************************
// Prototypes
//*****************************************************************************
boolean BSP_Initialisation(void);

//*****************************************************************************
// Definitions
//*****************************************************************************
//

// Port 2
// P2.0 ADF->MISO                 
// P2.3 ADF->CSN (GPIO controlled, rather than let SPI0 engine have it)
#define ADF_MISO_IN        (GP2IN  & (0x1UL << 0)) 
#define ADF_CSN_DEASSERT   (GP2SET = (0x1UL << 3)) 
#define ADF_CSN_ASSERT     (GP2CLR = (0x1UL << 3)) 

   // Send byte           
#define xFLUSH_SPI    SPI0CON |= SPI0CON_RFLUSH; SPI0CON &= ~SPI0CON_RFLUSH;
#define SEND_SPI(x)   SPI0TX = x
#define WAIT_SPI_RX   while((SPI0STA & SPI0STA_RXFSTA_MSK) == 0x0);
#define READ_SPI      SPI0RX

#define SPI_CLK_FREQ 4000000     // 4 Mhz SPI CLK
#define UCLK         16000000    // 16 Mhz UCLK





